﻿# -*- coding: utf-8 -*-
# La ligne ci-dessus évite les problèmes d'accents quand on passe d'un éditeur à l'autre.

import numpy as np
import matplotlib.pyplot as plt


# Données supposées être expérimentales :
hauteurs = [ np.random.rand()*10 for i in range(100) ]
temps_de_chute = [ np.sqrt(2*h/9.81)*(0.9+0.2*np.random.rand()) for h in hauteurs ]



g=9.8
def trace_droite(a,b):
    abscisses=np.linspace(0,12,100) #nb en réalité, deux points suffisent pour tracer une droite!
    ordonnées= [ a*x+b for x in abscisses ]
    plt.plot(abscisses, ordonnées, label="droite d'équation y = {}x+{}".format(a,b))

# Pour tracer la "vraie" courbe théorique
def trace_parabole():
    abscisses=np.linspace(0,12,100)
    ordonnées=[ (2*x/g)**0.5 for x in abscisses]
    plt.plot(abscisses, ordonnées) # Ceci crée le graphe mais ne l'affiche pas encore...


def test(a,b):
    """ Trace :
        la droite d'équation y==ax+b
        le nuage de points expérimental
        la courbe théorique """
    trace_droite(a,b)
    
    plt.scatter(hauteurs, temps_de_chute, label="données expérimentales")
    trace_parabole()
    
    plt.legend() # création de la légende
    plt.show()  #Affichage. Tous les graphes créés précédemment apparaîtront sur la même figure.


def lit_csv(chemin):
    fichier = open(chemin, "r") #Ouverture du fichier en lecture
    # On initialise les listes
    hauteurs=[]
    temps=[]
    
    for ligne in fichier: # Parcourt toutes les lignes du fichier
        
        h, t = ligne.strip().split(";")
        # Le .strip() supprime les caractères invisibles en début et fin de ligne. Ici les retours charriot.
        # Le .split(";") découpe la ligne selon les point-virgules
        
        # Il faut encore convertir h et t en flottant : ce sont actuellemens des chaînes de caractères.
        h=float(h)
        t=float(t)
        
        hauteurs.append(h)
        temps.append(t)
        
    fichier.close()
    return  hauteurs, temps





def crée_csv(chemin="/media/moi/CYRIL/formation/pour physique/pommes.csv"):
    """ Crée un fichier csv contenant des mesures de chute de pommes"""
    
    fichier = open(chemin, "w") #Ouverture du fichier en écriture
    for i in range(len(hauteurs)):
        fichier.write( str(hauteurs[i]) +";" + str(temps_de_chute[i])+"\n")
    fichier.close()
